/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BadInputException;
import edu.psu.bx.gmaj.Copyable;
import edu.psu.bx.gmaj.Feature;
import edu.psu.bx.gmaj.FeatureStyles;
import edu.psu.bx.gmaj.GenericAnnot;
import edu.psu.bx.gmaj.GenericAnnotList;
import edu.psu.bx.gmaj.IO;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Range;
import edu.psu.bx.gmaj.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class FeatureList
implements Copyable {
    static final String rcsid = "$Revision: 1.20 $$Date: 2008/01/18 18:52:29 $";
    String filename;
    int type;
    Vector regions;

    public FeatureList(String string, int n, Vector vector) {
        this.filename = string;
        this.type = n;
        this.regions = vector;
        vector.trimToSize();
    }

    public FeatureList(GenericAnnotList genericAnnotList, int n) {
        this(genericAnnotList, n, new Range(0, 0));
    }

    public FeatureList(GenericAnnotList genericAnnotList, int n, Range range) {
        this.filename = genericAnnotList.filename;
        this.type = n;
        this.regions = new Vector(genericAnnotList.regions.size());
        try {
            if (n == 1) {
                this.exonsFromGeneric(genericAnnotList, range);
            } else if (n == 2) {
                this.repeatsFromGeneric(genericAnnotList, range);
            } else {
                Log.fatalBug("FeatureList.FeatureList(): Invalid type.");
            }
        }
        catch (BadInputException badInputException) {
            Log.showError("Error loading features from file \"" + this.filename + "\":" + "\n" + badInputException);
        }
        this.regions.trimToSize();
    }

    public FeatureList(String string, int n) {
        this(string, null, n);
    }

    public FeatureList(String string, BufferedReader bufferedReader, int n) {
        this(string, bufferedReader, n, new Range(0, 0));
    }

    public FeatureList(String string, BufferedReader bufferedReader, int n, Range range) {
        this.filename = string;
        this.type = n;
        this.regions = new Vector();
        try {
            BufferedReader bufferedReader2 = bufferedReader;
            if (bufferedReader2 == null && string != null && !string.equals("")) {
                bufferedReader2 = IO.getReader(string);
            }
            if (bufferedReader2 != null) {
                switch (n) {
                    case 1: {
                        this.exonsFromReader(bufferedReader2, range);
                        break;
                    }
                    case 2: {
                        this.repeatsFromReader(bufferedReader2, range);
                        break;
                    }
                    default: {
                        Log.fatalBug("FeatureList.FeatureList(): Invalid type.");
                    }
                }
            }
            if (bufferedReader2 != null && bufferedReader2 != bufferedReader) {
                bufferedReader2.close();
            }
        }
        catch (IOException iOException) {
            Log.showError("Error loading features from" + (bufferedReader != null ? " bundled" : "") + " file \"" + string + "\":" + "\n" + iOException);
        }
        this.regions.trimToSize();
    }

    private void exonsFromGeneric(GenericAnnotList genericAnnotList, Range range) throws BadInputException {
        Object object;
        Vector<Object> vector = new Vector<Object>(genericAnnotList.regions.size());
        Enumeration enumeration = genericAnnotList.regions.elements();
        while (enumeration.hasMoreElements()) {
            object = (GenericAnnot)enumeration.nextElement();
            if (((GenericAnnot)object).format == 0) {
                this.prepareGffExon((GenericAnnot)object, genericAnnotList.filename);
            } else if (((GenericAnnot)object).format == 1) {
                this.prepareBedExon((GenericAnnot)object, genericAnnotList.filename);
            } else {
                Log.fatalBug("FeatureList.exonsFromGeneric(): Invalid format.");
            }
            if (((GenericAnnot)object).gene == null) {
                Log.showWarning("gene_missing", "Warning:\nSkipping lines without gene name when loading exons\n(e.g. from \"" + genericAnnotList.filename + "\").");
                continue;
            }
            vector.addElement(object);
        }
        if (vector.isEmpty()) {
            if (genericAnnotList.filename != null) {
                Log.showWarning("no_exons_" + genericAnnotList.filename + "_" + genericAnnotList.seqname, "Warning:\nNo usable exons found in file \"" + genericAnnotList.filename + "\"" + "\n" + "for sequence \"" + genericAnnotList.seqname + "\".");
            }
            return;
        }
        Collections.sort(vector, new Comparator(){

            public int compare(Object object, Object object2) {
                GenericAnnot genericAnnot = (GenericAnnot)object;
                GenericAnnot genericAnnot2 = (GenericAnnot)object2;
                int n = genericAnnot.gene.compareToIgnoreCase(genericAnnot2.gene);
                return n != 0 ? n : (genericAnnot.start < genericAnnot2.start ? -1 : (genericAnnot.start > genericAnnot2.start ? 1 : (genericAnnot.end > genericAnnot2.end ? -1 : (genericAnnot.end < genericAnnot2.end ? 1 : 0))));
            }
        });
        object = vector.elements();
        GenericAnnot genericAnnot = (GenericAnnot)object.nextElement();
        while (genericAnnot != null) {
            Range range2;
            Feature feature = null;
            Vector<Feature> vector2 = new Vector<Feature>();
            Range range3 = null;
            Range range4 = null;
            Range range5 = null;
            Range range6 = null;
            String string = genericAnnot.gene;
            int n = genericAnnot.dir;
            while (genericAnnot != null && genericAnnot.gene.equals(string)) {
                if (genericAnnot.dir != n) {
                    throw new BadInputException("Inconsistent strand for gene \"" + string + "\".");
                }
                range2 = new Range(genericAnnot.start, genericAnnot.end);
                Range range7 = range3 = range3 == null ? range2 : range3.grow(range2);
                if (genericAnnot.kind.equals("gene")) {
                    if (feature == null) {
                        feature = new Feature("Gene", genericAnnot.start, genericAnnot.end, genericAnnot.dir, genericAnnot.gene);
                    } else {
                        feature.start = Math.min(feature.start, genericAnnot.start);
                        feature.end = Math.max(feature.end, genericAnnot.end);
                    }
                } else if (genericAnnot.kind.equals("exon")) {
                    String string2 = genericAnnot.name == null || genericAnnot.name.equals(genericAnnot.gene) ? "" : genericAnnot.name;
                    vector2.addElement(new Feature("Exon", genericAnnot.start, genericAnnot.end, genericAnnot.dir, string2));
                } else if (genericAnnot.kind.equals("cds")) {
                    range6 = range6 == null ? range2 : range6.grow(range2);
                } else if (genericAnnot.kind.equals("start_codon")) {
                    range5 = range5 == null ? range2 : range5.grow(range2);
                } else if (genericAnnot.kind.equals("stop_codon")) {
                    range4 = range4 == null ? range2 : range4.grow(range2);
                }
                GenericAnnot genericAnnot2 = genericAnnot = object.hasMoreElements() ? (GenericAnnot)object.nextElement() : null;
            }
            if (range3 == null) {
                Log.fatalBug("FeatureList.exonsFromGeneric(): Null bounds.");
            }
            this.addExonLabels(string, vector2);
            range2 = this.findCDS(range6, range5, range4, range3, n, string, genericAnnotList.filename);
            if (range2 != null) {
                this.findUTRs(range2, vector2);
            }
            if (range.start != 0 && !range3.overlaps(range)) continue;
            if (feature != null) {
                this.regions.addElement(feature);
            }
            this.regions.addAll(vector2);
        }
    }

    private void prepareGffExon(GenericAnnot genericAnnot, String string) {
        if (genericAnnot.format != 0) {
            Log.fatalBug("FeatureList.prepareGffExon(): Wrong format.");
        }
        if (genericAnnot.gene == null && genericAnnot.group != null) {
            Log.showWarning("gff_group", "Warning:\nUsing GFF group as gene name when loading exons\n(e.g. from \"" + string + "\").");
            genericAnnot.gene = genericAnnot.group;
        }
    }

    private void prepareBedExon(GenericAnnot genericAnnot, String string) {
        if (genericAnnot.format != 1) {
            Log.fatalBug("FeatureList.prepareBedExon(): Wrong format.");
        }
        if (genericAnnot.gene != null) {
            Log.fatalBug("FeatureList.prepareBedExon(): Pre-existing BED gene.");
        }
        if (genericAnnot.name != null && !genericAnnot.name.equals("")) {
            if (genericAnnot.kind == null || genericAnnot.kind.equals("") || genericAnnot.kind.equals("cds_for_exon")) {
                int n = genericAnnot.name.indexOf(95);
                if (n <= 0) {
                    Log.showWarning("bed_name_full", "Warning:\nUsing full BED name as gene when loading exons\n(e.g. from \"" + string + "\").");
                    genericAnnot.gene = genericAnnot.name;
                } else {
                    Log.showWarning("bed_name_prefix", "Warning:\nUsing BED name prefix as gene when loading exons\n(e.g. from \"" + string + "\").");
                    genericAnnot.gene = Util.take(genericAnnot.name, n);
                }
            } else if (genericAnnot.kind.equals("gene") || genericAnnot.kind.equals("exon") || genericAnnot.kind.equals("cds")) {
                Log.showWarning("bed_name", "Warning:\nUsing BED name as gene when loading exons\n(e.g. from \"" + string + "\").");
                genericAnnot.gene = genericAnnot.name;
            } else {
                Log.fatalBug("FeatureList.prepareBedExon(): Invalid kind.");
            }
        }
        if (genericAnnot.kind == null || genericAnnot.kind.equals("")) {
            genericAnnot.kind = "exon";
        } else if (genericAnnot.kind.equals("cds_for_exon")) {
            genericAnnot.kind = "cds";
        }
    }

    private Range findCDS(Range range, Range range2, Range range3, Range range4, int n, String string, String string2) throws BadInputException {
        Range range5 = null;
        if (range == null && range2 == null && range3 == null) {
            return null;
        }
        if (n == 1 || n == -1) {
            int n2 = this.minStart(range, n == 1 ? range2 : range3, range4);
            int n3 = this.maxEnd(range, n == 1 ? range3 : range2, range4);
            if (n3 < n2 + 5) {
                throw new BadInputException("Bad start/stop codons for gene \"" + string + "\".");
            }
            range5 = new Range(n2, n3);
        } else {
            if (range2 != null && range3 != null) {
                range5 = new Range(range2).grow(range3);
            } else if (range2 != null || range3 != null) {
                Log.showWarning("ambiguous_codon", "Warning:\nSkipping lone start/stop codons when strand is unknown\n(e.g. from \"" + string2 + "\").");
            }
            if (range != null) {
                Range range6 = range5 = range5 == null ? new Range(range) : range5.grow(range);
            }
        }
        if (range5 != null && range5.equals(range4)) {
            range5 = null;
        }
        return range5;
    }

    private int minStart(Range range, Range range2, Range range3) {
        if (range3 == null) {
            Log.fatalBug("FeatureList.minStart(): Bounds is null.");
        }
        return range != null && range2 != null ? Math.min(range.start, range2.start) : (range != null ? range.start : (range2 != null ? range2.start : range3.start));
    }

    private int maxEnd(Range range, Range range2, Range range3) {
        if (range3 == null) {
            Log.fatalBug("FeatureList.maxEnd(): Bounds is null.");
        }
        return range != null && range2 != null ? Math.max(range.end, range2.end) : (range != null ? range.end : (range2 != null ? range2.end : range3.end));
    }

    private void exonsFromReader(BufferedReader bufferedReader, Range range) throws IOException {
        String string;
        Vector<Feature> vector = new Vector<Feature>();
        while ((string = IO.getNonemptyLine(bufferedReader)) != null && "<|>".indexOf(string.charAt(0)) < 0) {
        }
        if (string == null) {
            Log.showWarning("Warning:\nNo genes found in exons file.");
        }
        while (string != null) {
            Feature feature = this.readGene(string);
            Range range2 = null;
            vector.removeAllElements();
            while ((string = IO.getNonemptyLine(bufferedReader)) != null && "<|>".indexOf(string.charAt(0)) < 0) {
                if (string.startsWith("+")) {
                    range2 = this.readCDS(string);
                    continue;
                }
                vector.addElement(this.readExon(string, feature.dir));
            }
            this.addExonLabels(feature.label, vector);
            if (range2 != null) {
                this.findUTRs(range2, vector);
            }
            if (range.start != 0 && !Util.overlaps(feature.start, feature.end, range.start, range.end)) continue;
            this.regions.addElement(feature);
            this.regions.addAll(vector);
        }
    }

    private Feature readGene(String string) throws IOException {
        String string2 = String.valueOf(string.charAt(0));
        StringTokenizer stringTokenizer = new StringTokenizer(Util.drop(string, 1));
        if (stringTokenizer.countTokens() < 3) {
            throw new BadInputException("Invalid gene line: not enough tokens.\n" + string);
        }
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken("\n\r\f").trim();
        return new Feature("Gene", string3, string4, string2, string5);
    }

    private Range readCDS(String string) throws BadInputException {
        int n;
        int n2;
        StringTokenizer stringTokenizer = new StringTokenizer(Util.drop(string, 1));
        if (stringTokenizer.countTokens() != 2) {
            throw new BadInputException("Invalid translation region: wrong number of tokens.\n" + string);
        }
        try {
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadInputException("Invalid translation endpoint: not an integer.\n" + string);
        }
        if (n < n2) {
            throw new BadInputException("Invalid translation endpoints: end < start.\n" + string);
        }
        return new Range(n2, n);
    }

    private Feature readExon(String string, int n) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 2) {
            throw new BadInputException("Invalid exon line: not enough tokens.\n" + string);
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = !stringTokenizer.hasMoreTokens() ? "" : stringTokenizer.nextToken("\n\r\f").trim();
        return new Feature("Exon", string2, string3, n, string4);
    }

    private void addExonLabels(String string, Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Feature feature = (Feature)vector.elementAt(n2);
            int n3 = feature.dir == -1 ? n - n2 : n2 + 1;
            String string2 = string == null || string.equals("") || feature.label.startsWith(string) ? "" : string + ".";
            feature.label = string2 + (feature.label.equals("") ? String.valueOf(n3) : feature.label);
            ++n2;
        }
    }

    private void findUTRs(Range range, Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Feature feature = (Feature)vector.elementAt(n2);
            if (feature.start < range.start) {
                vector.addElement(new Feature("UTR", feature.start, Math.min(range.start - 1, feature.end), feature.dir, this.utrLabel(feature.dir, true)));
            }
            if (range.end < feature.end) {
                vector.addElement(new Feature("UTR", Math.max(range.end + 1, feature.start), feature.end, feature.dir, this.utrLabel(feature.dir, false)));
            }
            ++n2;
        }
    }

    private String utrLabel(int n, boolean bl) {
        if (n == 0) {
            return "UTR";
        }
        if (n == 1 == bl) {
            return "5'UTR";
        }
        return "3'UTR";
    }

    private void repeatsFromGeneric(GenericAnnotList genericAnnotList, Range range) throws BadInputException {
        Object object;
        Vector<Object> vector = new Vector<Object>(genericAnnotList.regions.size());
        boolean bl = false;
        Enumeration enumeration = genericAnnotList.regions.elements();
        while (enumeration.hasMoreElements()) {
            object = (GenericAnnot)enumeration.nextElement();
            if (((GenericAnnot)object).format == 0) {
                if (((GenericAnnot)object).kind.equals("exon") && ((GenericAnnot)object).gene != null) {
                    Log.showWarning("repeat_type_missing", "Warning:\nUsing \"Other\" for repeat type when class/family are not available\n(e.g. in \"" + genericAnnotList.filename + "\").");
                    ((GenericAnnot)object).kind = "Other";
                    if (((GenericAnnot)object).name == null) {
                        ((GenericAnnot)object).name = ((GenericAnnot)object).gene;
                    }
                }
                if (!FeatureStyles.isRepeat(((GenericAnnot)object).kind)) {
                    Log.showWarning("unrec_repeat", "Warning:\nSkipping lines with unrecognized repeat name/type\nwhen loading repeats (e.g. from \"" + genericAnnotList.filename + "\").");
                    continue;
                }
            } else if (((GenericAnnot)object).format == 1) {
                if (FeatureStyles.isRepeat(((GenericAnnot)object).name)) {
                    ((GenericAnnot)object).kind = ((GenericAnnot)object).name;
                } else {
                    bl = true;
                }
            } else {
                Log.fatalBug("FeatureList.repeatsFromGeneric(): Invalid format.");
            }
            vector.addElement(object);
        }
        if (vector.isEmpty()) {
            if (genericAnnotList.filename != null) {
                Log.showWarning("no_repeats_" + genericAnnotList.filename + "_" + genericAnnotList.seqname, "Warning:\nNo usable repeats found in file \"" + genericAnnotList.filename + "\"" + "\n" + "for sequence \"" + genericAnnotList.seqname + "\".");
            }
            return;
        }
        if (bl) {
            Log.showWarning("repeat_type_missing", "Warning:\nUsing \"Other\" for repeat type when class/family are not available\n(e.g. in \"" + genericAnnotList.filename + "\").");
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            GenericAnnot genericAnnot = (GenericAnnot)object.nextElement();
            if (bl && genericAnnot.format == 1) {
                genericAnnot.kind = "Other";
            }
            if (!FeatureStyles.isRepeat(genericAnnot.kind)) continue;
            String string = genericAnnot.name == null || genericAnnot.name.equals("") ? genericAnnot.kind : (genericAnnot.name.startsWith(genericAnnot.kind) ? genericAnnot.name : genericAnnot.kind + ":" + genericAnnot.name);
            Feature feature = new Feature(genericAnnot.kind, genericAnnot.start, genericAnnot.end, genericAnnot.dir, string);
            if (range.start != 0 && !Util.overlaps(feature.start, feature.end, range.start, range.end)) continue;
            this.regions.addElement(feature);
        }
        Collections.sort(this.regions, new Comparator(){

            public int compare(Object object, Object object2) {
                Feature feature = (Feature)object;
                Feature feature2 = (Feature)object2;
                int n = feature.end - feature.start;
                int n2 = feature2.end - feature2.start;
                return n > n2 ? -1 : (n < n2 ? 1 : (feature.start < feature2.start ? -1 : (feature.start > feature2.start ? 1 : 0)));
            }
        });
    }

    private void repeatsFromReader(BufferedReader bufferedReader, Range range) throws IOException {
        String string;
        while ((string = IO.getNonemptyLine(bufferedReader)) != null) {
            String string2;
            String string3;
            String string4;
            String string5;
            if (string.startsWith("%:repeats")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() == 4) {
                string5 = stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            } else if (stringTokenizer.countTokens() == 3) {
                string5 = stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
                string3 = "None";
                string2 = stringTokenizer.nextToken();
            } else {
                throw new BadInputException("Invalid repeat line: wrong number of tokens.\n" + string);
            }
            Feature feature = new Feature(string2, string5, string4, string3, string2);
            if (range.start != 0 && !Util.overlaps(feature.start, feature.end, range.start, range.end)) continue;
            this.regions.addElement(feature);
        }
    }

    public Vector findFeatures(int n) {
        Vector<Feature> vector = new Vector<Feature>();
        Enumeration enumeration = this.regions.elements();
        while (enumeration.hasMoreElements()) {
            Feature feature = (Feature)enumeration.nextElement();
            if (feature.start > n || n > feature.end) continue;
            vector.addElement(feature);
        }
        return vector;
    }

    public Copyable copy() {
        Vector<Copyable> vector = new Vector<Copyable>(this.regions.size());
        Enumeration enumeration = this.regions.elements();
        while (enumeration.hasMoreElements()) {
            Feature feature = (Feature)enumeration.nextElement();
            vector.addElement(feature.copy());
        }
        return new FeatureList(this.filename, this.type, vector);
    }
}

