/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BadInputException;
import edu.psu.bx.gmaj.Copyable;
import edu.psu.bx.gmaj.FeatureStyles;
import edu.psu.bx.gmaj.Log;

public class Feature
implements Copyable {
    static final String rcsid = "$Revision: 1.6 $$Date: 2006/04/03 22:35:26 $";
    static final int NONE = 0;
    static final int LEFT = -1;
    static final int RIGHT = 1;
    public String kind;
    public int start;
    public int end;
    public int dir;
    public String label;

    public Feature(String string, int n, int n2, int n3, String string2) {
        if (n2 < n) {
            Log.fatalBug("Feature.Feature(): Invalid endpoints: end < start.");
        }
        this.kind = string;
        this.start = n;
        this.end = n2;
        this.dir = n3;
        this.label = string2;
    }

    public Feature(String string, String string2, String string3, String string4, String string5) throws BadInputException {
        this(string, string2, string3, Feature.parseDir(string4), string5);
    }

    public Feature(String string, String string2, String string3, int n, String string4) throws BadInputException {
        if (!FeatureStyles.isKind(string)) {
            throw new BadInputException("Invalid feature kind \"" + string + "\".");
        }
        this.kind = string;
        try {
            this.start = Integer.parseInt(string2);
            this.end = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadInputException("Invalid feature endpoint: not an integer.");
        }
        if (this.end < this.start) {
            throw new BadInputException("Invalid feature endpoints: end < start.");
        }
        if (n != 0 && n != -1 && n != 1) {
            Log.fatalBug("Feature.Feature(): Invalid direction.");
        }
        this.dir = n;
        this.label = string4;
    }

    private static int parseDir(String string) throws BadInputException {
        if (string.equals("None") || string.equals("|")) {
            return 0;
        }
        if (string.equals("Left") || string.equals("<")) {
            return -1;
        }
        if (string.equals("Right") || string.equals(">")) {
            return 1;
        }
        throw new BadInputException("Invalid direction \"" + string + "\".");
    }

    public Copyable copy() {
        return new Feature(this.kind, this.start, this.end, this.dir, this.label);
    }
}

