/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BadInputException;
import edu.psu.bx.gmaj.Block;
import edu.psu.bx.gmaj.BlockRow;
import edu.psu.bx.gmaj.ExportChooser;
import edu.psu.bx.gmaj.IO;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.MajState;
import edu.psu.bx.gmaj.MarkInfo;
import edu.psu.bx.gmaj.Range;
import edu.psu.bx.gmaj.Util;
import java.awt.Rectangle;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.BitSet;
import java.util.Enumeration;

final class Exporter {
    static final String rcsid = "$Revision: 1.17 $$Date: 2008/06/20 21:46:51 $";
    Maj maj;
    MajState state;
    boolean post;
    boolean approved;
    String scope;
    boolean clip;
    boolean skipHidden;
    boolean skipLow;
    String format;
    boolean cleanup;
    boolean restoreRevcomp;
    String filebase;
    private BufferedWriter mfile;
    private BufferedWriter[] ffiles;
    private HttpURLConnection connect;

    public Exporter(Maj maj, MajState majState) {
        this.maj = maj;
        this.state = majState;
        this.post = maj.postUrl != null;
        ExportChooser exportChooser = new ExportChooser(majState.gui.frame, maj, majState, this.post);
        this.approved = exportChooser.showDialog();
        if (this.approved) {
            this.scope = ExportChooser.scope;
            this.clip = ExportChooser.clip;
            this.skipHidden = ExportChooser.skipHidden;
            this.skipLow = ExportChooser.skipLow;
            this.format = ExportChooser.format;
            this.cleanup = ExportChooser.cleanup;
            this.restoreRevcomp = ExportChooser.restoreRevcomp;
            this.filebase = ExportChooser.filebase;
        }
        this.mfile = null;
        this.ffiles = new BufferedWriter[maj.nseq];
        this.connect = null;
    }

    void doExport() {
        if (!this.approved) {
            return;
        }
        this.maj.repaintAllGuis(true);
        this.maj.setBusy(true);
        try {
            int n = 0;
            int n2 = 0;
            while (n2 < this.maj.bf.blocks.size()) {
                if (this.qualifies(n2) && this.exportBlock(n2)) {
                    ++n;
                }
                ++n2;
            }
            this.closeFiles();
            this.maj.setBusy(false);
            Log.showMessage(this.confirmMsg(n), "Export Complete");
        }
        catch (IOException iOException) {
            Log.showError("Error exporting data:\n" + iOException);
        }
        catch (SecurityException securityException) {
            Log.showError("Error exporting data:\n" + this.securityMsg(securityException));
        }
        this.maj.setBusy(false);
    }

    private boolean qualifies(int n) {
        if (this.scope.equals("block")) {
            MarkInfo markInfo = this.state.getMark();
            return markInfo != null && n == markInfo.blockno;
        }
        if (this.scope.equals("zoom")) {
            return this.state.overlaps(n, this.state.zt.getZoom());
        }
        if (this.scope.equals("tagged")) {
            return this.maj.global.isTagged(n);
        }
        if (this.scope.equals("visible")) {
            return this.maj.global.isVisible(n);
        }
        Log.fatalBug("Exporter.qualifies(): Unsupported scope.");
        return false;
    }

    private boolean exportBlock(int n) throws IOException {
        int n2;
        Object object;
        BlockRow blockRow;
        Object object2;
        Object object3;
        Block block = this.maj.bf.block(n);
        Rectangle rectangle = this.state.zt.getZoom();
        boolean bl = this.format.equals("maf");
        Range range = null;
        if (this.clip && rectangle != null) {
            object3 = block.row(this.state.refseq);
            range = this.getColumnClip((BlockRow)object3, (Range)(object2 = new Range(rectangle.x, rectangle.x + rectangle.width)));
            if (range != null && this.state.dotplot) {
                blockRow = block.row(this.state.seq2);
                object = new Range(rectangle.y, rectangle.y + rectangle.height);
                range = range.intersect(this.getColumnClip(blockRow, (Range)object));
            }
            if (range == null) {
                Log.warn("Skipping block " + n + " for export, due to clipping.");
                return false;
            }
        }
        object3 = new Block(block.bf, block.mafno, block.bno, block.ncols);
        object2 = block.rows.elements();
        while (object2.hasMoreElements()) {
            blockRow = (BlockRow)object2.nextElement();
            if (this.skipHidden && !this.maj.global.getShown(blockRow.seqno) || this.skipLow && blockRow.seqno != this.state.refseq && ((object = (Object)this.state.view.plots[blockRow.seqno].block(n)) == null || object.pm < this.maj.global.ilimit)) continue;
            object = this.clipRow(blockRow, range);
            if (object == null || Util.countNonGap(object.text) == 0) {
                n2 = this.maj.bf.seqno(this.maj.specs.getRefSeq());
                if (blockRow.seqno != n2 || this.format.equals("fasta")) continue;
                Log.warn("Skipping block " + n + " for export:" + " fixed refseq is all gaps.");
                return false;
            }
            ((Block)object3).append((BlockRow)object);
        }
        if (((Block)object3).rows.isEmpty() || bl && this.cleanup && ((Block)object3).rows.size() < 2) {
            return false;
        }
        blockRow = bl && this.cleanup ? this.keepCols((Block)object3) : null;
        object = bl ? this.mafWidths((Block)object3) : null;
        n2 = 1;
        Enumeration enumeration = ((Block)object3).rows.elements();
        while (enumeration.hasMoreElements()) {
            BlockRow blockRow2 = (BlockRow)enumeration.nextElement();
            try {
                if (bl) {
                    this.rowToMaf(blockRow2, n, (BitSet)((Object)blockRow), (int[])object, n2 != 0);
                } else if (this.format.equals("fasta")) {
                    this.rowToFasta(blockRow2, ((Block)object3).mafno, ((Block)object3).bno);
                } else {
                    Log.fatalBug("Exporter.exportBlock(): Unsupported format.");
                }
                n2 = 0;
            }
            catch (IOException iOException) {
                throw new IOException("Error exporting row \"" + this.maj.bf.seqname(blockRow2.seqno) + "\" from block " + n + ":" + "\n" + iOException);
            }
        }
        return !((Block)object3).rows.isEmpty();
    }

    private Range getColumnClip(BlockRow blockRow, Range range) {
        if (blockRow == null || range == null || !Util.overlaps(blockRow.start, blockRow.end, range.start, range.end)) {
            return null;
        }
        int n = -1;
        int n2 = -1;
        int n3 = blockRow.text.length() - 1;
        if (Util.clamp(blockRow.start, range.start, blockRow.end) == range.start) {
            n = blockRow.coordToCol(range.start);
        }
        if (Util.clamp(blockRow.start, range.end, blockRow.end) == range.end) {
            n2 = blockRow.coordToCol(range.end);
        }
        if (!blockRow.reverseComp) {
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = n3;
            }
        } else {
            if (n < 0) {
                n = n3;
            }
            if (n2 < 0) {
                n2 = 0;
            }
        }
        return new Range(n, n2);
    }

    private BlockRow clipRow(BlockRow blockRow, Range range) {
        int n = blockRow.start;
        int n2 = blockRow.end;
        String string = blockRow.text;
        if (range != null) {
            Range range2 = this.getSequenceClip(blockRow, range);
            if (range2 == null) {
                return null;
            }
            n = blockRow.reverseComp ? range2.end : range2.start;
            n2 = blockRow.reverseComp ? range2.start : range2.end;
            string = string.substring(range.start, range.end + 1);
        }
        return new BlockRow(blockRow.seqno, blockRow.reverseComp, n, n2, string);
    }

    private Range getSequenceClip(BlockRow blockRow, Range range) {
        if (blockRow == null || range == null) {
            return null;
        }
        int n = range.start;
        int n2 = range.end;
        int n3 = blockRow.text.length() - 1;
        if (n < 0 || n2 > n3) {
            Log.fatalBug("Exporter.getSequenceClip(): Column outside bounds.");
        }
        while (n <= n3 && blockRow.text.charAt(n) == '-') {
            ++n;
        }
        while (n2 >= 0 && blockRow.text.charAt(n2) == '-') {
            --n2;
        }
        if (n > n2) {
            return null;
        }
        return new Range(blockRow.colToCoord(n), blockRow.colToCoord(n2));
    }

    private BitSet keepCols(Block block) {
        BitSet bitSet = new BitSet();
        Enumeration enumeration = block.rows.elements();
        while (enumeration.hasMoreElements()) {
            BlockRow blockRow = (BlockRow)enumeration.nextElement();
            int n = 0;
            while (n < blockRow.text.length()) {
                if (blockRow.text.charAt(n) != '-') {
                    bitSet.set(n);
                }
                ++n;
            }
        }
        return bitSet;
    }

    private int[] mafWidths(Block block) {
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = block.rows.elements();
        while (enumeration.hasMoreElements()) {
            BlockRow blockRow = (BlockRow)enumeration.nextElement();
            n = Math.max(n, this.maj.bf.mafseqname(blockRow.seqno).length());
            n2 = Math.max(n2, this.maj.bf.seqref((int)blockRow.seqno).len);
        }
        return new int[]{n, Integer.toString(n2).length(), Integer.toString(block.ncols).length()};
    }

    private void rowToMaf(BlockRow blockRow, int n, BitSet bitSet, int[] nArray, boolean bl) throws IOException {
        Appendable appendable;
        int n2 = this.maj.bf.seqref((int)blockRow.seqno).len;
        int n3 = blockRow.reverseComp ? n2 - blockRow.start : blockRow.start - 1;
        int n4 = Math.abs(blockRow.end - blockRow.start) + 1;
        String string = blockRow.text;
        if (this.cleanup) {
            appendable = new StringBuffer(string.length() + 1);
            int n5 = 0;
            while (n5 < string.length()) {
                char c = string.charAt(n5);
                if (bitSet.get(n5)) {
                    ((StringBuffer)appendable).append(c);
                } else if (c != '-') {
                    Log.fatalBug("Exporter.rowToMaf(): Removed column is not all gaps.");
                }
                ++n5;
            }
            if (((StringBuffer)appendable).length() == 0) {
                Log.fatalBug("Exporter.rowToMaf(): No columns left in row.");
            }
            string = ((StringBuffer)appendable).toString();
        }
        if (Util.countNonGap(string) != n4) {
            Log.fatalBug("Exporter.rowToMaf(): Bad sequence length.");
        }
        if (this.mfile == null) {
            this.mfile = this.openMaf();
        }
        appendable = this.mfile;
        if (bl) {
            ((Writer)appendable).write(IO.EOLP);
            ((Writer)appendable).write("# block " + this.maj.bf.blockname(n) + IO.EOLP);
            ((Writer)appendable).write("a" + IO.EOLP);
        }
        ((Writer)appendable).write("s " + Util.label(this.maj.bf.mafseqname(blockRow.seqno), nArray[0]));
        ((Writer)appendable).write(" " + Util.label(n3, nArray[1]));
        ((Writer)appendable).write(" " + Util.label(n4, nArray[2]));
        ((Writer)appendable).write(" " + (blockRow.reverseComp ? "-" : "+"));
        ((Writer)appendable).write(" " + Util.label(n2, nArray[1]));
        ((Writer)appendable).write(" " + string);
        ((Writer)appendable).write(IO.EOLP);
    }

    private void rowToFasta(BlockRow blockRow, int n, int n2) throws IOException {
        int n3 = blockRow.start;
        int n4 = blockRow.end;
        String string = blockRow.text;
        string = Util.stripChar('-', string);
        if (blockRow.reverseComp && this.restoreRevcomp) {
            string = Util.reverseComplement(string);
            int n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        if (blockRow.reverseComp && !this.restoreRevcomp) {
            if (n3 < n4) {
                Log.fatalBug("Exporter.rowToFasta(): Bad endpoint order.");
            }
        } else if (n3 > n4) {
            Log.fatalBug("Exporter.rowToFasta(): Bad endpoint order.");
        }
        if (string.length() != Math.abs(n4 - n3) + 1) {
            Log.fatalBug("Exporter.rowToFasta(): Bad sequence length.");
        }
        if (this.ffiles[blockRow.seqno] == null) {
            String string2 = this.filebase + this.maj.bf.seqname(blockRow.seqno) + ".fa";
            this.ffiles[blockRow.seqno] = new BufferedWriter(new FileWriter(string2, true));
        }
        BufferedWriter bufferedWriter = this.ffiles[blockRow.seqno];
        bufferedWriter.write(">" + this.maj.bf.mafseqname(blockRow.seqno) + " " + n3 + "-" + n4 + " [exported by " + Log.programName + " from block " + n2 + " of " + this.maj.bf.mafname(n) + "; aligns " + (blockRow.reverseComp ? "-" : "+") + "]" + IO.EOLP);
        bufferedWriter.write(Util.wrapLines(string, 50, IO.EOLP) + IO.EOLP);
        bufferedWriter.write(IO.EOLP);
    }

    private BufferedWriter openMaf() throws IOException {
        BufferedWriter bufferedWriter;
        Object object;
        if (this.post) {
            URLConnection uRLConnection;
            object = this.maj.postUrl;
            if (object == null) {
                Log.fatalBug("Exporter.openMaf(): No POST url specified.");
            }
            if (!((uRLConnection = ((URL)object).openConnection()) instanceof HttpURLConnection)) {
                throw new BadInputException("URL for posting output must use HTTP.\n\"" + this.maj.postUrl + "\"");
            }
            this.connect = (HttpURLConnection)uRLConnection;
            this.connect.setRequestMethod("POST");
            this.connect.setDoOutput(true);
            this.connect.setAllowUserInteraction(true);
            this.connect.setUseCaches(false);
            this.connect.setRequestProperty("Content-Type", "multipart/form-data; boundary=______AaB03x");
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.connect.getOutputStream()));
            bufferedWriter.write("\r\n--______AaB03x\r\n");
            bufferedWriter.write("Content-Disposition: form-data; name=file_data; filename=Gmaj_output.maf\r\n");
            bufferedWriter.write("Content-Type: application/octet-stream\r\n");
            bufferedWriter.write("\r\n");
        } else {
            object = this.filebase + ".maf";
            bufferedWriter = new BufferedWriter(new FileWriter((String)object, true));
        }
        bufferedWriter.write("##maf version=1 program=exported_from_" + Log.programName + IO.EOLP);
        bufferedWriter.write("# alignfile=");
        int n = 0;
        while (n < this.maj.nmaf) {
            bufferedWriter.write((n == 0 ? "" : ",") + (this.maj.nmaf > 1 ? n + ":" : "") + this.maj.bf.mafname(n));
            ++n;
        }
        bufferedWriter.write("; scope=" + this.scope);
        bufferedWriter.write("; clip=" + this.clip);
        bufferedWriter.write("; skipHidden=" + this.skipHidden);
        bufferedWriter.write("; skipLow=" + this.skipLow);
        bufferedWriter.write("; format=" + this.format);
        bufferedWriter.write("; cleanup=" + this.cleanup);
        bufferedWriter.write(IO.EOLP);
        bufferedWriter.write("#");
        return bufferedWriter;
    }

    private void closeMaf() throws IOException {
        BufferedWriter bufferedWriter = this.mfile;
        bufferedWriter.write(IO.EOLP);
        bufferedWriter.write("##eof maf" + IO.EOLP);
        if (this.post) {
            bufferedWriter.write("\r\n--______AaB03x--\r\n");
            bufferedWriter.flush();
            bufferedWriter.close();
            int n = this.connect.getResponseCode();
            if (n < 200 || n >= 300) {
                throw new IOException("Error posting alignments:\n" + n + ": " + this.connect.getResponseMessage());
            }
            Log.warn("Exported alignments posted successfully.");
            this.connect.disconnect();
        } else {
            bufferedWriter.flush();
            bufferedWriter.close();
        }
    }

    private void closeFiles() throws IOException {
        if (this.mfile != null) {
            this.closeMaf();
            this.mfile = null;
        }
        int n = 0;
        while (n < this.ffiles.length) {
            if (this.ffiles[n] != null) {
                this.ffiles[n].flush();
                this.ffiles[n].close();
                this.ffiles[n] = null;
            }
            ++n;
        }
        this.connect = null;
    }

    private String confirmMsg(int n) {
        String string = this.post ? "designated URL" : this.filebase + (this.format.equals("maf") ? ".maf" : (this.format.equals("fasta") ? "*.fa" : ".???"));
        return n + " block" + (n == 1 ? "" : "s") + " exported" + (n > 0 ? " to " + string : "; no file created") + ".";
    }

    private String securityMsg(SecurityException securityException) {
        return "A SecurityException has occurred, probably when attempting\nto post the exported data to the designated server.  Please\ncontact the applet administrator or webmaster for assistance.\n\n" + securityException;
    }
}

