/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BadInputException;
import edu.psu.bx.gmaj.Chooser;
import edu.psu.bx.gmaj.IO;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.MajState;
import edu.psu.bx.gmaj.MarkInfo;
import edu.psu.bx.gmaj.MultiLineLabel;
import edu.psu.bx.gmaj.Util;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ExportChooser
extends Chooser {
    static final String rcsid = "$Revision: 1.16 $$Date: 2008/06/20 21:46:51 $";
    private static final String BLOCK = "the current block";
    private static final String ZOOM = "all blocks that overlap the current zoom region";
    private static final String TAGGED = "all tagged blocks";
    private static final String VISIBLE = "all blocks in visible categories (MAFs/Tagged)";
    private static final String MAF = "MAF alignment";
    private static final String FASTA = "FastA sequences";
    private static final Insets nogap = new Insets(0, 0, 0, 0);
    Maj maj;
    MajState state;
    boolean post;
    static String scope;
    static boolean clip;
    static boolean skipHidden;
    static boolean skipLow;
    static String format;
    static boolean cleanup;
    static boolean restoreRevcomp;
    static String filebase;
    private JComboBox scopebox;
    private JComboBox formatbox;
    private JCheckBox clipbox;
    private JCheckBox showbox;
    private JCheckBox lowbox;
    private JCheckBox cleanbox;
    private JCheckBox revbox;
    private MultiLineLabel cleanlabel;
    private MultiLineLabel revlabel;
    private JTextField filebox;
    private JFileChooser browse;
    private String[] scopeOptions = new String[]{"the current block", "all blocks that overlap the current zoom region", "all tagged blocks", "all blocks in visible categories (MAFs/Tagged)"};
    private String[] scopeResults = new String[]{"block", "zoom", "tagged", "visible"};
    private String[] formatOptions = new String[]{"MAF alignment", "FastA sequences"};
    private String[] formatResults = new String[]{"maf", "fasta"};

    public ExportChooser(JFrame jFrame, Maj maj, MajState majState, boolean bl) {
        super(jFrame, "Export Data");
        Object object;
        String[] stringArray;
        this.maj = maj;
        this.state = majState;
        this.post = bl;
        JPanel jPanel = this.content;
        this.scopebox = new JComboBox<String>(this.scopeOptions);
        String string = this.translate(scope, this.scopeResults, this.scopeOptions);
        if (string != null) {
            this.scopebox.setSelectedItem(string);
        }
        this.scopebox.setMaximumSize(this.scopebox.getMinimumSize());
        jPanel.add(this.widgetPanel("Data to export:", this.scopebox));
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.clipbox = new JCheckBox("", clip);
        String string2 = "Clip block(s) to zoom region";
        jPanel.add(this.widgetPanel("", this.clipbox, new MultiLineLabel(string2, this, nogap)));
        this.showbox = new JCheckBox("", skipHidden);
        String string3 = "Omit sequences that are hidden in the Show options";
        jPanel.add(this.widgetPanel("", this.showbox, new MultiLineLabel(string3, this, nogap)));
        this.lowbox = new JCheckBox("", skipLow);
        String string4 = "Omit rows that align below the % Identity threshold";
        jPanel.add(this.widgetPanel("", this.lowbox, new MultiLineLabel(string4, this, nogap)));
        jPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        if (bl) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = MAF;
        } else {
            stringArray = this.formatOptions;
        }
        this.formatbox = new JComboBox<String>(stringArray);
        string = this.translate(format, this.formatResults, this.formatOptions);
        if (string != null) {
            this.formatbox.setSelectedItem(string);
        }
        this.formatbox.setMaximumSize(this.formatbox.getMinimumSize());
        this.formatbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ((String)ExportChooser.this.formatbox.getSelectedItem()).equals(ExportChooser.MAF);
                ExportChooser.this.cleanbox.setEnabled(bl);
                ExportChooser.this.cleanlabel.setEnabled(bl);
                boolean bl2 = ((String)ExportChooser.this.formatbox.getSelectedItem()).equals(ExportChooser.FASTA);
                ExportChooser.this.revbox.setEnabled(bl2);
                ExportChooser.this.revlabel.setEnabled(bl2);
            }
        });
        jPanel.add(this.widgetPanel("Output format:", this.formatbox));
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        this.cleanbox = new JCheckBox("", cleanup);
        String string5 = "For MAF export, remove all-gap columns and blocks with only one row";
        this.cleanlabel = new MultiLineLabel(string5, this, nogap);
        jPanel.add(this.widgetPanel("", this.cleanbox, this.cleanlabel));
        this.revbox = new JCheckBox("", restoreRevcomp);
        String string6 = "For FastA export, restore sequences that align in reverse complement\nto their original orientation";
        this.revlabel = new MultiLineLabel(string6, this, nogap);
        if (!bl) {
            jPanel.add(this.widgetPanel("", this.revbox, this.revlabel));
            jPanel.add(Box.createRigidArea(new Dimension(0, 15)));
        }
        this.filebox = new JTextField("", 50);
        try {
            if (filebase != null && !filebase.equals("")) {
                this.filebox.setText(new File(filebase).getCanonicalPath());
            } else {
                this.filebox.setText(new File(".").getCanonicalPath() + File.separator);
            }
        }
        catch (IOException iOException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (!bl) {
            this.browse = new JFileChooser();
            this.browse.setDialogTitle("File name:");
            this.browse.setApproveButtonText("OK");
            this.browse.setFileSelectionMode(2);
            object = new JButton("Browse");
            ((AbstractButton)object).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    File file = new File(ExportChooser.this.filebox.getText());
                    while (file != null && !file.exists()) {
                        file = file.getParentFile();
                    }
                    if (file == null) {
                        file = new File(".");
                    }
                    ExportChooser.this.browse.setCurrentDirectory(file);
                    ExportChooser.this.browse.rescanCurrentDirectory();
                    ExportChooser.this.browse.ensureFileIsVisible(file);
                    int n = ExportChooser.this.browse.showDialog(ExportChooser.this, null);
                    if (n == 0) {
                        ExportChooser.this.filebox.setText(ExportChooser.this.browse.getSelectedFile().getPath());
                    }
                }
            });
            jPanel.add(this.widgetPanel("Output file:", this.filebox, (JComponent)object));
            jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        object = "-  Do not use an existing file name.\n-  Gmaj will append an appropriate extension (e.g. \".fa\").\n-  For FastA exports, multiple files will be generated, adding each\n    sequence name to the base name you specify.";
        if (!bl) {
            jPanel.add(this.widgetPanel("     Tips:", new MultiLineLabel((String)object, this)));
        }
        Util.adjustChildren(jPanel, 0.0f, 0.5f, 0, 0);
        this.pack();
        this.setLocationRelativeTo(jFrame);
        this.formatbox.setSelectedItem(this.formatbox.getSelectedItem());
    }

    private String translate(String string, String[] stringArray, String[] stringArray2) {
        int n = stringArray.length;
        if (n != stringArray2.length) {
            Log.fatalBug("ExportChooser.translate(): Array length mismatch.");
        }
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2].equals(string)) {
                return stringArray2[n2];
            }
            ++n2;
        }
        return null;
    }

    protected boolean validateInput() {
        Rectangle rectangle = this.state.zt.getZoom();
        MarkInfo markInfo = this.state.getMark();
        String string = (String)this.scopebox.getSelectedItem();
        scope = this.translate(string, this.scopeOptions, this.scopeResults);
        if (scope == null) {
            Log.fatalBug("ExportChooser.validateInput(): Invalid scope value.");
        }
        if (scope.equals("block") && markInfo == null) {
            Log.showError("There is no block currently selected.");
            return false;
        }
        if (scope.equals("zoom")) {
            int n = this.maj.bf.blocks.size();
            int n2 = 0;
            while (n2 < n) {
                if (this.state.overlaps(n2, rectangle)) break;
                ++n2;
            }
            if (n2 >= n) {
                Log.showError("There are no blocks in the current zoom region.");
                return false;
            }
        }
        if (scope.equals("tagged") && this.maj.global.tagcount == 0) {
            Log.showError("There are no blocks currently tagged.");
            return false;
        }
        if (scope.equals("visible") && Util.countSetBits(this.maj.global.showMafs) == 0 && (!this.maj.global.showTagged || this.maj.global.tagcount == 0)) {
            Log.showError("There are no blocks currently visible.");
            return false;
        }
        clip = this.clipbox.isSelected();
        if (clip && rectangle == null) {
            Log.showError("Can't clip: there is no current zoom region.");
            return false;
        }
        if (clip && scope.equals("block") && !this.state.overlaps(markInfo.blockno, rectangle)) {
            Log.showError("Can't clip: current block is outside zoom region.");
            return false;
        }
        skipHidden = this.showbox.isSelected();
        skipLow = this.lowbox.isSelected();
        string = (String)this.formatbox.getSelectedItem();
        format = this.translate(string, this.formatOptions, this.formatResults);
        if (format == null) {
            Log.fatalBug("ExportChooser.validateInput(): Invalid format value.");
        }
        cleanup = this.cleanbox.isSelected();
        restoreRevcomp = this.revbox.isSelected();
        if (this.post) {
            filebase = "";
        } else {
            block27: {
                string = this.filebox.getText();
                if (string == null || string.equals("")) {
                    Log.showError("No file name specified.");
                    return false;
                }
                try {
                    string = Util.unquote(string);
                }
                catch (BadInputException badInputException) {
                    Log.showError(badInputException.toString());
                    return false;
                }
                if (new File(string).isDirectory()) {
                    Log.showError("\"" + string + "\" is a directory." + "\n" + "Please specify a file name.");
                    return false;
                }
                if (format.equals("maf")) {
                    if (string.endsWith(".maf")) {
                        string = Util.take(string, string.length() - 4);
                    }
                    try {
                        if (new File(string + ".maf").exists()) {
                            Log.showError("File \"" + string + ".maf\"" + "\n" + "already exists.  Please use a different name.");
                            return false;
                        }
                        break block27;
                    }
                    catch (SecurityException securityException) {
                        Log.showError("SecurityException when checking for existence of file\n\"" + string + ".maf\":" + "\n" + securityException);
                        return false;
                    }
                }
                if (format.equals("fasta")) {
                    if (string.endsWith(".fa")) {
                        string = Util.take(string, string.length() - 3);
                    }
                    if (!string.endsWith("-")) {
                        string = string + "-";
                    }
                    try {
                        if (IO.prefixInUse(string)) {
                            Log.showError("Files like \"" + string + "*\"" + "\n" + "already exist.  Please use a different name.");
                            return false;
                        }
                    }
                    catch (IOException iOException) {
                        Log.showError("Error when checking for existing files like\n\"" + string + "*\":" + "\n" + iOException);
                        return false;
                    }
                }
            }
            filebase = string;
        }
        return true;
    }
}

