/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BadInputException;
import edu.psu.bx.gmaj.Config;
import edu.psu.bx.gmaj.Copyable;
import edu.psu.bx.gmaj.FeatureList;
import edu.psu.bx.gmaj.GenericAnnot;
import edu.psu.bx.gmaj.GenericAnnotList;
import edu.psu.bx.gmaj.InputSpecs;
import edu.psu.bx.gmaj.LinkbarList;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.UnderlayList;
import edu.psu.bx.gmaj.Util;
import java.io.BufferedReader;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class DataCloset {
    static final String rcsid = "$Revision: 1.7 $$Date: 2008/01/18 18:52:29 $";
    InputSpecs specs;
    private Hashtable cache;
    private FeatureList noexons;
    private FeatureList norepeats;
    private LinkbarList nolinks;
    private UnderlayList nounderlays;
    private GenericAnnotList nogeneric;
    private Hashtable bundled;

    public DataCloset(InputSpecs inputSpecs) {
        this.specs = inputSpecs;
        this.cache = new Hashtable();
        this.noexons = new FeatureList((String)null, 1);
        this.norepeats = new FeatureList((String)null, 2);
        this.nolinks = new LinkbarList(null);
        this.nounderlays = new UnderlayList(null);
        this.nogeneric = new GenericAnnotList(null);
        this.bundled = new Hashtable();
    }

    public Copyable get(InputSpecs.AnnotSpec annotSpec, int n, String string) {
        String string2;
        if (annotSpec == null) {
            return this.empty(n).copy();
        }
        String string3 = annotSpec.filename;
        String string4 = string3;
        if (!this.cache.containsKey(string4)) {
            string2 = this.specs.findFile(string3);
            int n2 = InputSpecs.priorityType(this.specs.inferTypes(string3));
            this.cache.put(string4, string2 == null ? this.empty(string3, n2) : this.load(string2, n2, null));
        }
        string2 = annotSpec.seqalias != null ? annotSpec.seqalias : string;
        Copyable copyable = this.convert((Copyable)this.cache.get(string4), n, annotSpec.typehint, string2, string3);
        if (copyable.getClass() != this.empty(n).getClass()) {
            Log.fatalBug("DataCloset.get(): Class mismatch.");
        }
        return copyable;
    }

    public void loadBundledFile(String string, BitSet bitSet, BufferedReader bufferedReader) throws BadInputException {
        if (bitSet.get(0)) {
            throw new BadInputException("Invalid use of \"" + string + "\" in parameters file:" + "\n" + "reuse of MAF as annotation.");
        }
        int n = InputSpecs.priorityType(bitSet);
        if (!this.put(string, this.load(string, n, bufferedReader))) {
            throw new BadInputException("Zip entry name \"" + string + "\" is not unique.");
        }
        this.bundled.put(string, "");
    }

    public void clean() {
        Enumeration enumeration = this.cache.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = string = (String)enumeration.nextElement();
            Copyable copyable = (Copyable)this.cache.get(string);
            if (this.isBundled(string2) && (copyable instanceof UnderlayList || copyable instanceof GenericAnnotList)) continue;
            this.cache.remove(string);
        }
    }

    private Copyable empty(int n) {
        return this.empty(null, n);
    }

    private Copyable empty(String string, int n) {
        Copyable copyable = null;
        if (string != null && this.isGenericFormat(string)) {
            copyable = this.nogeneric;
        } else {
            switch (n) {
                case 1: {
                    copyable = this.noexons;
                    break;
                }
                case 2: {
                    copyable = this.norepeats;
                    break;
                }
                case 3: {
                    copyable = this.nolinks;
                    break;
                }
                case 4: 
                case 5: {
                    copyable = this.nounderlays;
                    break;
                }
                default: {
                    Log.fatalBug("DataCloset.empty(): Invalid filetype.");
                }
            }
        }
        return copyable;
    }

    private Copyable load(String string, int n, BufferedReader bufferedReader) {
        Copyable copyable = null;
        if (this.isGenericFormat(string)) {
            copyable = new GenericAnnotList(string, bufferedReader);
        } else {
            switch (n) {
                case 1: 
                case 2: {
                    copyable = new FeatureList(string, bufferedReader, n);
                    break;
                }
                case 3: {
                    copyable = new LinkbarList(string, bufferedReader);
                    break;
                }
                case 4: 
                case 5: {
                    copyable = new UnderlayList(string, bufferedReader);
                    break;
                }
                default: {
                    Log.fatalBug("DataCloset.load(): Invalid filetype.");
                }
            }
        }
        return copyable;
    }

    private boolean put(String string, Copyable copyable) {
        String string2 = string;
        if (!this.cache.containsKey(string2)) {
            this.cache.put(string2, copyable);
            return true;
        }
        return false;
    }

    private Copyable convert(Copyable copyable, int n, int n2, String string, String string2) {
        if (copyable.getClass() == this.empty(n).getClass()) {
            return copyable.copy();
        }
        if (copyable instanceof GenericAnnotList) {
            GenericAnnotList genericAnnotList = this.filter((GenericAnnotList)copyable, string);
            switch (n) {
                case 1: 
                case 2: {
                    return new FeatureList(genericAnnotList, n);
                }
                case 3: {
                    return new LinkbarList(genericAnnotList, n2);
                }
                case 4: 
                case 5: {
                    return new UnderlayList(genericAnnotList, n2);
                }
            }
            Log.fatalBug("DataCloset.convert(): Invalid filetype.");
            return null;
        }
        if (!this.isEmpty(copyable)) {
            String string3 = this.formatFromClass(copyable);
            String string4 = InputSpecs.typeName(n);
            Log.showError("convert_" + string2 + "_" + string4, "Error loading annotations from" + (this.isBundled(string2) ? " bundled" : "") + " file \"" + string2 + "\":" + "\n" + "Conversion of " + string3 + " format to " + string4 + "s is not supported.");
        }
        return this.empty(n).copy();
    }

    private boolean isEmpty(Copyable copyable) {
        try {
            Vector vector = (Vector)copyable.getClass().getDeclaredField("regions").get(copyable);
            return vector.isEmpty();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private GenericAnnotList filter(GenericAnnotList genericAnnotList, String string) {
        boolean bl = genericAnnotList.seqname == null || !genericAnnotList.seqname.equals("");
        Vector<Copyable> vector = new Vector<Copyable>(genericAnnotList.regions.size());
        Enumeration enumeration = genericAnnotList.regions.elements();
        while (enumeration.hasMoreElements()) {
            GenericAnnot genericAnnot = (GenericAnnot)enumeration.nextElement();
            if (!genericAnnot.seqname.equals(string)) {
                if (!bl) continue;
                String string2 = Util.orgName(string) + "." + genericAnnot.seqname;
                String string3 = Util.orgName(string) + ".chr" + genericAnnot.seqname;
                if (!string2.equals(string) && !string3.equals(string)) {
                    Log.showWarning("seqname_mismatch", "Warning:\nSequence name in annotation file does not match\nthe expected value from MAF or parameters file\n(e.g. \"" + genericAnnot.seqname + "\" in file" + "\n" + "\"" + genericAnnotList.filename + "\"" + "\n" + "when expecting \"" + string + "\")." + "\n" + "\n" + "However when there is only one sequence name in an" + "\n" + "annotation file, mismatches like this are allowed.");
                }
            }
            vector.addElement(genericAnnot.copy());
        }
        return new GenericAnnotList(genericAnnotList.filename, vector, string, genericAnnotList.trackName);
    }

    private boolean isBundled(String string) {
        return this.bundled.containsKey(string);
    }

    private boolean isGenericFormat(String string) {
        String string2 = string.toLowerCase();
        if (string2.endsWith(".gz") || string2.endsWith(".zip") || string2.endsWith(".jar")) {
            int n = string2.lastIndexOf(46);
            string2 = Util.take(string2, n).trim();
        }
        Vector vector = !this.specs.getTabExt().isEmpty() ? this.specs.getTabExt() : Config.defaultTabExt;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string2.endsWith(string3)) continue;
            return true;
        }
        return false;
    }

    private String formatFromClass(Copyable copyable) {
        if (copyable instanceof LinkbarList) {
            return InputSpecs.typeName(3);
        }
        if (copyable instanceof FeatureList) {
            FeatureList featureList = (FeatureList)copyable;
            return InputSpecs.typeName(featureList.type);
        }
        if (copyable instanceof UnderlayList) {
            return InputSpecs.typeName(4);
        }
        if (copyable instanceof GenericAnnotList) {
            return "GFF/BED";
        }
        return "(unknown format)";
    }
}

