/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.ColorTable;
import edu.psu.bx.gmaj.Util;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;

final class Config {
    static final String rcsid = "$Revision: 1.47 $$Date: 2008/05/06 18:22:32 $";
    static final Color backgroundColor = Color.white;
    static final Color emptyBackgroundColor = ColorTable.getColor("LightGray");
    static final Color textBackgroundColor = new Color(225, 225, 225);
    static final Color foregroundColor = Color.black;
    static final Color[] fileColor = new Color[]{Color.black, ColorTable.getColor("Brown")};
    static final Color markColor = Color.red;
    static final Color tagColor = new Color(0, 204, 0);
    static final Color tagLabelColor = new Color(0, 170, 0);
    static final Color tagMarkColor = ColorTable.getColor("Orange");
    static final Color zoomBarColor = Color.blue;
    static final Color rulerColor1 = ColorTable.getColor("DarkGray");
    static final Color rulerColor2 = ColorTable.getColor("Black");
    static final Color dividerColor = ColorTable.getColor("LightGray");
    static final Color guideColor = Color.gray;
    static final Color caretColor = Color.white;
    static final Color thumbColor = new Color(153, 153, 204);
    static final Color barColor = Color.black;
    static final Color defaultAnnotColor = ColorTable.getColor("LightGray");
    static final FontUIResource menuFont1 = new FontUIResource("Dialog", 1, 12);
    static final FontUIResource menuFont2 = new FontUIResource("Dialog", 1, 16);
    static final FontUIResource inputFont1 = new FontUIResource("Monospaced", 0, 14);
    static final FontUIResource inputFont2 = new FontUIResource("Monospaced", 0, 16);
    static final FontUIResource outputFont1 = new FontUIResource("Monospaced", 0, 14);
    static final FontUIResource outputFont2 = new FontUIResource("Monospaced", 0, 16);
    static final FontUIResource headerFont1 = new FontUIResource("Monospaced", 1, 14);
    static final FontUIResource headerFont2 = new FontUIResource("Monospaced", 1, 16);
    static final FontUIResource tickFont1 = new FontUIResource("Dialog", 0, 10);
    static final FontUIResource tickFont2 = new FontUIResource("Dialog", 0, 14);
    static final FontUIResource waitFont = new FontUIResource("Dialog", 0, 18);
    static final Cursor arrowCursor = Cursor.getPredefinedCursor(0);
    static final Cursor waitCursor = Cursor.getPredefinedCursor(3);
    static final String correctnessLabel = "   correctness";
    static final String presentnessLabel = "   presentness";
    static final String linkLabel = "   links";
    static final String exonLabel = "   exons";
    static final String repeatLabel = "   repeats+";
    static final String postBoundary = "______AaB03x";
    static final String postFieldName = "file_data";
    static final String postFileName = "Gmaj_output.maf";
    static final String helpDoc = "docs/gmaj_help.html";
    static final String selfSuffix = "~";
    static final Vector defaultTabExt = new Vector<String>(Arrays.asList(".gff", ".gtf", ".bed", ".ct", ".trk"));
    static final Insets zoomMargin = new Insets(4, 6, 4, 6);
    static final Insets zoomBarInsets = new Insets(0, 1, 0, 1);
    static final Border barZoomBorder = Util.paddedBorder(zoomMargin, zoomBarInsets, null, zoomBarColor);
    static final Border nobarZoomBorder = Util.paddedBorder(zoomMargin, zoomBarInsets, null, backgroundColor);
    static final Insets headerPanelMargin = new Insets(4, 0, 6, 5);
    static final Insets textPanelMargin = new Insets(4, 15, 6, 15);
    static final Border waitBorder = Util.paddedBorder(null, new Insets(20, 20, 20, 20), new Insets(15, 30, 15, 30), thumbColor);
    static final int plotThickness1 = 1;
    static final int plotThickness2 = 3;
    static final int markThickness1 = 1;
    static final int markThickness2 = 2;
    static final int markRadius1 = 5;
    static final int markRadius2 = 7;
    static final int linkBarThickness = 3;
    static final int linkRowHeight = 6;
    static final int tickLeading = 2;
    static final int hatchSize = 4;
    static final int scrollBarWidth = 15;
    static final int splitDividerWidth = 8;
    static final int maxCanvasWidth = 9999;
    static final int frameOffsetX = 60;
    static final int frameOffsetY = 20;
    static final int frameWider = 100;
    static final int barHeight = 30;
    static final int featureHeight = 25;
    static final int pipHeight1 = 50;
    static final int pipHeight2 = 70;
    static final int dragLimit = 3;
    static final int pipTop = 100;
    static final int pipBottom = 50;
    static final int virtualSequenceMargin = 0;
    static final int zoomLimit = 4;
    static final int defaultUrlPause = 100;
    static final int startingCols = 80;
    static final int fileChooserCols = 50;
    static final int zoomChooserCols = 12;
    static final int fastaCols = 50;
    static final int messageCols = 120;
    static final int tabSpaces = 3;
    static final int fractionDigits = 2;
    static final int tickTarget = 4;
    static final int minBlockButtons = 2;
    static final int dotHeightFactor = 8;
    static final double extentPad = 0.05;
    static final double maxFrameHeightRatio = 0.9;
    static final double loc_zinfoResizeWeight = 1.0;
    static final double info_blocksResizeWeight = 1.0;
    static final double pips_textResizeWeight = 0.7;
    static String fontset;
    static FontUIResource menuFont;
    static FontUIResource inputFont;
    static FontUIResource outputFont;
    static FontUIResource headerFont;
    static FontUIResource tickFont;
    static Color rulerColor;
    static int plotThickness;
    static int markThickness;
    static int markRadius;
    static int pipHeight;
    static int dotHeight;
    static String markMode;
    static Dimension multipipFrameSize;
    static Dimension dotplotFrameSize;

    Config() {
    }

    static void setSmallFonts() {
        fontset = "small";
        menuFont = menuFont1;
        inputFont = inputFont1;
        outputFont = outputFont1;
        headerFont = headerFont1;
        tickFont = tickFont1;
        rulerColor = rulerColor1;
        plotThickness = 1;
        markThickness = 1;
        markRadius = 5;
        pipHeight = 50;
        dotHeight = pipHeight * 8;
    }

    static void setLargeFonts() {
        fontset = "large";
        menuFont = menuFont2;
        inputFont = inputFont2;
        outputFont = outputFont2;
        headerFont = headerFont2;
        tickFont = tickFont2;
        rulerColor = rulerColor2;
        plotThickness = 3;
        markThickness = 2;
        markRadius = 7;
        pipHeight = 70;
        dotHeight = pipHeight * 8;
    }

    static void setMarkMode(String string) {
        markMode = string;
    }

    static void setMultipipFrameSize(Dimension dimension) {
        multipipFrameSize = dimension;
    }

    static void setDotplotFrameSize(Dimension dimension) {
        dotplotFrameSize = dimension;
    }

    static Color getFileColor(int n) {
        int n2 = fileColor.length;
        return n < n2 ? fileColor[n] : fileColor[n2 - 1];
    }

    static boolean isReconRow(String string) {
        return string != null && (string.equals("correct") || string.equals("present"));
    }

    static {
        multipipFrameSize = null;
        dotplotFrameSize = null;
    }
}

