/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.MajState;
import edu.psu.bx.gmaj.MarkInfo;
import edu.psu.bx.gmaj.PlotBlock;
import edu.psu.bx.gmaj.Util;
import java.util.BitSet;

final class BlockText {
    static final String rcsid = "$Revision: 1.6 $$Date: 2008/06/30 18:22:44 $";
    String[] rows;
    String[] headers;
    int[] seqnos;
    private BitSet shownRows;

    BlockText(String[] stringArray, String[] stringArray2, int[] nArray) {
        int n;
        if (stringArray == null || stringArray2 == null || nArray == null) {
            Log.fatalBug("BlockText.BlockText(): Array is null.");
        }
        if (stringArray2.length != (n = stringArray.length) || nArray.length != n) {
            Log.fatalBug("BlockText.BlockText(): Array lengths differ.");
        }
        if (n == 0) {
            Log.fatalBug("BlockText.BlockText(): Arrays are empty.");
        }
        this.rows = stringArray;
        this.headers = stringArray2;
        this.seqnos = nArray;
        this.shownRows = new BitSet();
    }

    boolean setVisible(Maj maj, MajState majState) {
        MarkInfo markInfo = majState.getMark();
        if (markInfo == null) {
            Log.fatalBug("BlockText.setVisible(): Mark is null.");
        }
        Integer n = new Integer(markInfo.blockno);
        boolean bl = !this.shownRows.get(0);
        this.shownRows.set(0);
        int n2 = 1;
        while (n2 < this.rows.length) {
            int n3 = this.seqnos[n2];
            PlotBlock plotBlock = majState.view.plots[n3].block(n);
            if (plotBlock == null) {
                Log.fatalBug("BlockText.setVisible(): Plot block is null.");
            }
            if (majState.dotplot && n3 != majState.seq2 || !maj.global.getShown(n3) || plotBlock.pm < maj.global.ilimit) {
                bl = bl || this.shownRows.get(n2);
                this.shownRows.clear(n2);
            } else {
                bl = bl || !this.shownRows.get(n2);
                this.shownRows.set(n2);
            }
            ++n2;
        }
        return bl;
    }

    String[] getVisibleRows() {
        int n = Util.countSetBits(this.shownRows);
        String[] stringArray = new String[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.rows.length) {
            if (this.shownRows.get(n3)) {
                stringArray[n2++] = this.rows[n3];
            }
            ++n3;
        }
        if (n2 != n) {
            Log.fatalBug("BlockText.getVisibleRows(): Array length error.");
        }
        return stringArray;
    }

    String[] getVisibleHeaders() {
        int n = Util.countSetBits(this.shownRows);
        String[] stringArray = new String[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.headers.length) {
            if (this.shownRows.get(n3)) {
                stringArray[n2++] = this.headers[n3];
            }
            ++n3;
        }
        if (n2 != n) {
            Log.fatalBug("BlockText.getVisibleHeaders(): Array length error.");
        }
        return stringArray;
    }

    int getDisplayIndex(int n) {
        if (n < 0 || n >= this.rows.length) {
            Log.fatalBug("BlockText.getDisplayIndex(): Bad index.");
        }
        if (!this.shownRows.get(n)) {
            return -1;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (this.shownRows.get(n3)) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    int getFullIndex(int n) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.rows.length) {
            if (this.shownRows.get(n3) && ++n2 == n) {
                return n3;
            }
            ++n3;
        }
        Log.fatalBug("BlockText.getFullIndex(): Bad index.");
        return -1;
    }
}

