/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.Config;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.MajState;
import edu.psu.bx.gmaj.Util;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class BlockSelector
extends JPanel {
    static final String rcsid = "$Revision: 1.12 $$Date: 2008/05/19 22:23:00 $";
    Maj maj;
    MajState state;
    Vector buttons;
    JToggleButton selected;
    private JLabel hdr;
    private JPanel p;
    private JScrollPane sp;
    private boolean halfway;

    public BlockSelector(Maj maj, MajState majState) {
        this.maj = maj;
        this.state = majState;
        this.buttons = new Vector();
        this.halfway = false;
        this.hdr = new JLabel("Blocks: ");
        this.p = new JPanel();
        this.p.setLayout(new BoxLayout(this.p, 0));
        this.sp = new JScrollPane(this.p);
        this.sp.setVerticalScrollBarPolicy(21);
        this.sp.setBorder(BorderFactory.createLineBorder(Config.guideColor));
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.hdr);
        this.add(this.sp);
    }

    public void setButtons(Vector vector, int n) {
        int n2;
        AbstractAction abstractAction = null;
        this.buttons.clear();
        this.p.removeAll();
        this.selected = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            n2 = (Integer)enumeration.nextElement();
            final JToggleButton jToggleButton = new JToggleButton(Integer.toString(n2));
            jToggleButton.setFocusPainted(false);
            jToggleButton.setMargin(new Insets(0, 0, 0, 0));
            if (n2 != n) {
                AbstractAction abstractAction2 = new AbstractAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        BlockSelector.this.state.setMark(n2);
                        BlockSelector.this.state.gui.restoreFocus();
                    }
                };
                jToggleButton.addActionListener(abstractAction2);
                if (this.buttons.size() == 0) {
                    abstractAction = abstractAction2;
                } else if (((JToggleButton)this.buttons.lastElement()).isSelected()) {
                    jToggleButton.getInputMap(2).put(KeyStroke.getKeyStroke('n'), "block");
                    jToggleButton.getActionMap().put("block", abstractAction2);
                }
            } else {
                jToggleButton.setSelected(true);
                jToggleButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                2.access$000(this.this$1).setSelected(true);
                            }
                        });
                    }

                    static /* synthetic */ JToggleButton access$000(2 var0) {
                        return var0.jToggleButton;
                    }
                });
                if (this.selected != null) {
                    Log.fatalBug("BlockSelector.setButtons(): Duplicate block.");
                }
                this.selected = jToggleButton;
            }
            this.buttons.addElement(jToggleButton);
            this.p.add(jToggleButton);
        }
        if (this.buttons.size() > 1 && ((JToggleButton)this.buttons.lastElement()).isSelected()) {
            JToggleButton jToggleButton = (JToggleButton)this.buttons.firstElement();
            jToggleButton.getInputMap(2).put(KeyStroke.getKeyStroke('n'), "block");
            jToggleButton.getActionMap().put("block", abstractAction);
        }
        int n3 = (n2 = this.buttons.size()) > 0 ? this.p.getPreferredSize().width / n2 : 0;
        this.sp.getHorizontalScrollBar().setUnitIncrement(n3);
    }

    private void scrollToCurrent() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (BlockSelector.this.buttons.isEmpty() || BlockSelector.this.selected == null) {
                    return;
                }
                try {
                    Rectangle rectangle = BlockSelector.this.selected.getBounds(null);
                    JViewport jViewport = BlockSelector.this.sp.getViewport();
                    Rectangle rectangle2 = jViewport.getViewRect();
                    int n = BlockSelector.this.p.getWidth() - rectangle2.width;
                    int n2 = rectangle.x < rectangle2.x || rectangle.x + rectangle.width > rectangle2.x + rectangle2.width ? Util.clamp(0, rectangle.x + rectangle.width / 2 - rectangle2.width / 2, n) : rectangle2.x;
                    int n3 = 0;
                    while (n3 < 10) {
                        jViewport.setViewPosition(new Point(n2, 0));
                        Point point = jViewport.getViewPosition();
                        if (point.x != n2 || point.y != 0) {
                            ++n3;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    Log.warn("Can't scroll block buttons to current one.");
                }
            }
        });
    }

    public Dimension getPreferredSize() {
        return this.isPreferredSizeSet() ? super.getPreferredSize() : new Dimension(this.getPrefWidth(this.buttons.size()), this.getPrefHeight());
    }

    public Dimension getMinimumSize() {
        return this.isMinimumSizeSet() ? super.getMinimumSize() : new Dimension(0, this.getPrefHeight());
    }

    public Dimension getMinimumSizeForReset() {
        return new Dimension(this.getPrefWidth(2), this.getPrefHeight());
    }

    public Dimension getMaximumSize() {
        return this.isMaximumSizeSet() ? super.getMaximumSize() : new Dimension(9999, this.getPrefHeight());
    }

    private int getPrefWidth(int n) {
        Insets insets = this.sp.getInsets();
        Insets insets2 = this.getInsets();
        int n2 = this.hdr.getPreferredSize().width;
        if (this.buttons.size() > n) {
            JToggleButton jToggleButton = (JToggleButton)this.buttons.firstElement();
            n2 += (int)((double)jToggleButton.getPreferredSize().width * ((double)n + 0.5));
        } else {
            n2 += this.p.getPreferredSize().width;
        }
        if (insets != null) {
            n2 += insets.left + insets.right;
        }
        if (insets2 != null) {
            n2 += insets2.left + insets2.right;
        }
        return n2;
    }

    private int getPrefHeight() {
        JViewport jViewport = this.sp.getViewport();
        Insets insets = this.sp.getInsets();
        Insets insets2 = this.getInsets();
        int n = this.p.getPreferredSize().height;
        if (this.getWidth() > this.hdr.getWidth() && jViewport.getExtentSize().width < jViewport.getViewSize().width) {
            n += UIManager.getInt("ScrollBar.width");
        }
        if (insets != null) {
            n += insets.top + insets.bottom;
        }
        n = Math.max(this.hdr.getPreferredSize().height, n);
        if (insets2 != null) {
            n += insets2.top + insets2.bottom;
        }
        return n;
    }

    public void doLayout() {
        super.doLayout();
        if (this.halfway) {
            this.halfway = false;
        } else {
            this.halfway = true;
            this.scrollToCurrent();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BlockSelector.this.revalidate();
                }
            });
        }
    }
}

