/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BlockFile;
import edu.psu.bx.gmaj.BlockRow;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Range;
import edu.psu.bx.gmaj.Util;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class BlockIndex {
    static final String rcsid = "$Revision: 1.2 $$Date: 2006/02/21 01:20:18 $";
    private BlockFile bf;
    private int refseq;
    private Vector tree;

    public BlockIndex(BlockFile blockFile, int n) {
        int n2;
        Object object;
        this.bf = blockFile;
        this.refseq = n;
        this.tree = new Vector(blockFile.blocks.size());
        Vector<BlockNode> vector = new Vector<BlockNode>(blockFile.blocks.size());
        int n3 = 0;
        while (n3 < blockFile.blocks.size()) {
            object = blockFile.block(n3).row(n);
            if (object != null) {
                int n4 = Math.min(((BlockRow)object).start, ((BlockRow)object).end);
                n2 = Math.max(((BlockRow)object).start, ((BlockRow)object).end);
                vector.addElement(new BlockNode(n4, n2, -1, n3));
            }
            ++n3;
        }
        Collections.sort(vector, new Comparator(){

            public int compare(Object object, Object object2) {
                BlockNode blockNode = (BlockNode)object;
                BlockNode blockNode2 = (BlockNode)object2;
                return blockNode.start < blockNode2.start ? -1 : (blockNode.start > blockNode2.start ? 1 : (blockNode.end < blockNode2.end ? -1 : (blockNode.end > blockNode2.end ? 1 : (blockNode.blockno < blockNode2.blockno ? -1 : (blockNode.blockno > blockNode2.blockno ? 1 : 0)))));
            }
        });
        object = new Vector();
        if (vector.size() > 0) {
            ((Vector)object).add(new Range(0, vector.size() - 1));
        }
        while (!((Vector)object).isEmpty()) {
            Range range = (Range)((Vector)object).remove(0);
            n2 = this.calcRoot(range);
            this.tree.addElement(vector.elementAt(n2));
            if (range.start < n2) {
                ((Vector)object).add(new Range(range.start, n2 - 1));
                if (n2 >= range.end) continue;
                ((Vector)object).add(new Range(n2 + 1, range.end));
                continue;
            }
            if (n2 >= range.end) continue;
            Log.fatalBug("BlockIndex.BlockIndex(): Right child without left.");
        }
        if (this.tree.size() != vector.size()) {
            Log.fatalBug("BlockIndex.BlockIndex(): Tree has wrong size.");
        }
        if (this.tree.size() > 0) {
            this.calcMax(0, this.tree);
        }
        this.tree.trimToSize();
    }

    private int calcRoot(Range range) {
        int n;
        int n2 = range.end - range.start + 1;
        int n3 = (int)Math.floor(Math.log((double)n2 + 0.5) / Math.log(2.0));
        int n4 = n2 - (Util.pow(2, n3) - 1);
        int n5 = n4 >= (n = Util.pow(2, n3 - 1)) ? Util.pow(2, n3) - 1 : Util.pow(2, n3 - 1) - 1 + n4;
        return range.start + n5;
    }

    private int calcMax(int n, Vector vector) {
        int n2;
        BlockNode blockNode = (BlockNode)vector.elementAt(n);
        blockNode.max = blockNode.end;
        int n3 = n * 2 + 1;
        if (n3 < vector.size()) {
            blockNode.max = Math.max(blockNode.max, this.calcMax(n3, vector));
        }
        if ((n2 = n3 + 1) < vector.size()) {
            blockNode.max = Math.max(blockNode.max, this.calcMax(n2, vector));
        }
        return blockNode.max;
    }

    public Vector search(int n) {
        Vector vector = new Vector();
        this.search(n, 0, vector);
        return vector;
    }

    private void search(int n, int n2, Vector vector) {
        int n3;
        BlockNode blockNode = (BlockNode)this.tree.elementAt(n2);
        if (n > blockNode.max) {
            return;
        }
        int n4 = n2 * 2 + 1;
        if (n4 < this.tree.size()) {
            this.search(n, n4, vector);
        }
        if (n < blockNode.start) {
            return;
        }
        if (n <= blockNode.end) {
            vector.addElement(new Integer(blockNode.blockno));
        }
        if ((n3 = n4 + 1) < this.tree.size()) {
            this.search(n, n3, vector);
        }
    }

    public void print() {
        int n = 0;
        while (n < this.tree.size()) {
            BlockNode blockNode = (BlockNode)this.tree.elementAt(n);
            System.err.println("node " + n + ": " + blockNode.start + "-" + blockNode.end + "; " + blockNode.max + "; " + blockNode.blockno);
            ++n;
        }
        System.err.println();
    }

    static final class BlockNode {
        int start;
        int end;
        int max;
        int blockno;

        BlockNode(int n, int n2, int n3, int n4) {
            this.start = n;
            this.end = n2;
            this.max = n3;
            this.blockno = n4;
        }
    }
}

