/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BadInputException;
import edu.psu.bx.gmaj.Block;
import edu.psu.bx.gmaj.IO;
import edu.psu.bx.gmaj.InputSpecs;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.MafReader;
import edu.psu.bx.gmaj.Range;
import edu.psu.bx.gmaj.ReconScores;
import edu.psu.bx.gmaj.SeqRef;
import edu.psu.bx.gmaj.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BlockFile {
    static final String rcsid = "$Revision: 1.38 $$Date: 2008/06/11 01:59:42 $";
    InputSpecs specs;
    int self;
    String selfname;
    Vector mafnames;
    Vector seqrefs;
    Vector blocks;
    Vector scores;
    private Vector extents;
    private BitSet loaded;

    public BlockFile(InputSpecs inputSpecs) {
        this.specs = inputSpecs;
        this.self = 0;
        this.selfname = null;
        this.mafnames = new Vector();
        Enumeration enumeration = inputSpecs.getAlignFiles().elements();
        while (enumeration.hasMoreElements()) {
            this.mafnames.addElement(IO.pathlessName((String)enumeration.nextElement()));
        }
        this.seqrefs = new Vector();
        this.blocks = new Vector();
        this.scores = new Vector();
        this.extents = new Vector();
        this.loaded = new BitSet();
    }

    public void loadFromSpecs() {
        Object object;
        Vector vector = this.specs.getAlignFiles();
        int n = Util.countSetBits(this.loaded);
        String string = null;
        try {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                this.loadFile(string, null);
            }
            string = null;
            this.checkSeqnos();
        }
        catch (IOException iOException) {
            object = string == null ? "" : " from file \"" + string + "\"";
            Log.showError("Error loading alignments" + (String)object + ":" + "\n" + iOException);
            Log.exit(1);
        }
        if (this.blocks.size() == 0) {
            Log.showError("MAF files contain no alignments.");
            Log.exit(1);
        }
        if (this.seqrefs.size() == 0) {
            Log.showError("Master sequence list built from MAF files is empty.");
            Log.exit(1);
        }
        if (vector.size() > 1 && n > 0) {
            Collections.sort(this.blocks, new Comparator(){

                public int compare(Object object, Object object2) {
                    Block block = (Block)object;
                    Block block2 = (Block)object2;
                    return block.mafno < block2.mafno ? -1 : (block.mafno > block2.mafno ? 1 : (block.bno < block2.bno ? -1 : (block.bno > block2.bno ? 1 : 0)));
                }
            });
        }
        int n2 = 0;
        while (n2 < this.scores.size()) {
            object = (Hashtable)this.scores.elementAt(n2);
            Enumeration enumeration = ((Hashtable)object).keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Vector vector2 = (Vector)((Hashtable)object).get(string2);
                if (vector2 == null || vector2.size() <= 0) continue;
                try {
                    ((Hashtable)object).put(string2, this.consolidateAnnot(n2, string2, vector2));
                }
                catch (BadInputException badInputException) {
                    Log.showError("Error loading reconstruction scores:\n" + badInputException);
                    Log.exit(1);
                }
            }
            ++n2;
        }
        this.seqrefs.trimToSize();
        this.blocks.trimToSize();
        this.scores.trimToSize();
        this.extents.setSize(this.seqrefs.size());
        this.extents.trimToSize();
    }

    public void loadFile(String string, BufferedReader bufferedReader) throws IOException {
        int n = this.specs.getAlignFiles().indexOf(string);
        if (n < 0) {
            Log.showWarning("unused_maf", "Warning:\nSkipping unused file \"" + string + "\": not in parameters file.");
            return;
        }
        if (this.loaded.get(n)) {
            Log.warn("File \"" + string + "\" already loaded from bundle.");
            return;
        }
        this.loaded.set(n);
        if (bufferedReader != null) {
            this.fromReader(bufferedReader, n);
        } else {
            String string2 = this.specs.findFile(string);
            if (string2 == null) {
                Log.exit(1);
            }
            BufferedReader bufferedReader2 = IO.getReader(string2);
            this.fromReader(bufferedReader2, n);
            bufferedReader2.close();
        }
    }

    private void fromReader(BufferedReader bufferedReader, int n) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null && string.trim().equals("")) {
        }
        if (string == null) {
            throw new BadInputException("The input file is empty.");
        }
        if (!string.startsWith("##maf")) {
            throw new BadInputException("The input is not a ##maf file.");
        }
        new MafReader(string, bufferedReader, this, n);
    }

    private void checkSeqnos() throws BadInputException {
        if (!this.specs.usingSpecs()) {
            return;
        }
        int n = Math.max(this.seqrefs.size() - 1, this.specs.getMaxSeq());
        int n2 = 0;
        while (n2 <= n) {
            if (n2 >= this.seqrefs.size() || this.seqref(n2) == null) {
                if (this.specs.isSeqUsed(n2)) {
                    String string = this.specs.getSeqName(n2);
                    throw new BadInputException("Sequence " + n2 + ", \"" + string + "\"," + "\n" + "does not appear in any alignment blocks.");
                }
                throw new BadInputException("Sequence number " + n2 + " is left unused." + "\n" + "(Perhaps numbers in " + this.specs.getSpecFile() + " are too high?)");
            }
            ++n2;
        }
    }

    private Vector consolidateAnnot(int n, String string, Vector vector) throws BadInputException {
        int n2;
        Vector<ReconScores> vector2 = new Vector<ReconScores>();
        int n3 = -1;
        int n4 = -1;
        if (this.specs.getReconOrg().equals("none")) {
            return vector2;
        }
        Collections.sort(vector, new Comparator(){

            public int compare(Object object, Object object2) {
                int n;
                ReconScores reconScores = (ReconScores)object;
                ReconScores reconScores2 = (ReconScores)object2;
                int n2 = reconScores == null ? -1 : reconScores.range.start;
                int n3 = n = reconScores2 == null ? -1 : reconScores2.range.start;
                return n2 < n ? -1 : (n2 == n ? 0 : 1);
            }
        });
        int n5 = 0;
        while (n5 < vector.size()) {
            ReconScores reconScores = (ReconScores)vector.elementAt(n5);
            n2 = reconScores.range.start;
            int n6 = reconScores.range.end;
            if (n4 < 0 || n2 > n4 + 1) {
                if (n4 >= 0) {
                    Log.warn("Threading failed for row \"" + string + "\":" + " no scores for [" + (n4 + 1) + ", " + (n2 - 1) + "] in \"" + this.seqname(n) + "\".");
                    vector2.addElement(this.groupAnnot(vector, n3, n5 - 1));
                }
                n3 = n5;
                n4 = n6;
            } else if (n2 == n4 + 1) {
                n4 = n6;
            } else {
                ReconScores reconScores2 = (ReconScores)vector.elementAt(n5 - 1);
                boolean bl = this.specs.getAlignFiles().size() > 1;
                throw new BadInputException("Overlapping scores for row \"" + string + "\" at" + "\n" + "[" + reconScores2.range.start + ".." + reconScores2.range.end + "] and [" + n2 + ".." + n6 + "]" + "\n" + "in \"" + this.seqname(n) + "\"" + (bl ? " (possibly from different MAFs)" : "") + ".");
            }
            ++n5;
        }
        if (n4 >= 0) {
            vector2.addElement(this.groupAnnot(vector, n3, vector.size() - 1));
            int n7 = ((ReconScores)vector2.firstElement()).range.start;
            n2 = ((ReconScores)vector2.lastElement()).range.end;
            if (n7 != 1 || n2 != this.seqref((int)n).len) {
                Log.warn("Observed range for row \"" + string + "\" is [" + n7 + ", " + n2 + "] in \"" + this.seqname(n) + "\" (out of [1, " + this.seqref((int)n).len + "]).");
            }
        }
        vector2.trimToSize();
        return vector2;
    }

    private ReconScores groupAnnot(Vector vector, int n, int n2) {
        Object object;
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            object = (ReconScores)vector.elementAt(n4);
            n3 += object.scores.length;
            ++n4;
        }
        object = new float[n3];
        int n5 = 0;
        int n6 = n;
        while (n6 <= n2) {
            ReconScores reconScores = (ReconScores)vector.elementAt(n6);
            int n7 = 0;
            while (n7 < reconScores.scores.length) {
                object[n5++] = reconScores.scores[n7];
                ++n7;
            }
            ++n6;
        }
        if (n5 != ((float[])object).length) {
            Log.fatalBug("BlockFile.groupAnnot(): Bad array length.");
        }
        return new ReconScores(((ReconScores)vector.elementAt((int)n)).range.start, ((ReconScores)vector.elementAt((int)n2)).range.end, (float[])object);
    }

    public String mafname(int n) throws IndexOutOfBoundsException {
        return (String)this.mafnames.elementAt(n);
    }

    public SeqRef seqref(int n) throws IndexOutOfBoundsException {
        return (SeqRef)this.seqrefs.elementAt(n);
    }

    public Block block(int n) throws IndexOutOfBoundsException {
        return (Block)this.blocks.elementAt(n);
    }

    public Vector scoreset(int n, String string) throws IndexOutOfBoundsException {
        Hashtable hashtable = (Hashtable)this.scores.elementAt(n);
        return (Vector)hashtable.get(string);
    }

    public String seqname(int n) throws IndexOutOfBoundsException {
        return this.seqref((int)n).filename;
    }

    public String mafseqname(int n) throws IndexOutOfBoundsException {
        String string = this.seqname(n);
        if (string.endsWith("~")) {
            string = Util.take(string, string.length() - "~".length());
        }
        return string;
    }

    public int seqno(String string) {
        int n = 0;
        while (n < this.seqrefs.size()) {
            if (this.seqname(n).equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int maxMafSeqnameLength() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.seqrefs.size()) {
            int n3 = this.mafseqname(n2).length();
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public String blockname(int n) throws IndexOutOfBoundsException {
        Block block = this.block(n);
        return (this.mafnames.size() > 1 ? block.mafno + "." : "") + block.bno;
    }

    public int blockno(int n, int n2) {
        int n3 = 0;
        while (n3 < this.blocks.size()) {
            Block block = this.block(n3);
            if (block.mafno == n && block.bno == n2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public Range getBounds(int n) {
        return new Range(1, this.seqref((int)n).len);
    }

    public Range getExtent(int n) {
        Range range = (Range)this.extents.get(n);
        if (range == null) {
            Enumeration enumeration = this.blocks.elements();
            while (enumeration.hasMoreElements()) {
                Block block = (Block)enumeration.nextElement();
                if (block.rows.size() <= 1) continue;
                Range range2 = block.getExtent(n);
                Range range3 = range = range == null ? range2 : range.grow(range2);
            }
            this.extents.set(n, range);
        }
        return range;
    }

    public String sequenceSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.seqrefs.size()) {
            Range range = this.getExtent(n);
            stringBuffer.append("\n" + this.mafseqname(n) + ":" + range.start + "-" + range.end);
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean anyRecon() {
        if (this.specs.getReconOrg().equals("none")) {
            return false;
        }
        int n = 0;
        while (n < this.scores.size()) {
            Hashtable hashtable = (Hashtable)this.scores.elementAt(n);
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                Vector vector = (Vector)enumeration.nextElement();
                if (vector == null || vector.size() <= 0) continue;
                return true;
            }
            ++n;
        }
        return false;
    }
}

