/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.BlockFile;
import edu.psu.bx.gmaj.BlockRow;
import edu.psu.bx.gmaj.BlockText;
import edu.psu.bx.gmaj.Log;
import edu.psu.bx.gmaj.Range;
import edu.psu.bx.gmaj.Util;
import java.util.Enumeration;
import java.util.Vector;

public class Block {
    static final String rcsid = "$Revision: 1.12 $$Date: 2008/01/18 18:52:29 $";
    BlockFile bf;
    int mafno;
    int bno;
    int ncols;
    Vector rows;

    public Block(BlockFile blockFile, int n, int n2, int n3) {
        this.bf = blockFile;
        this.mafno = n;
        this.bno = n2;
        this.ncols = n3;
        this.rows = new Vector();
    }

    public void append(BlockRow blockRow) {
        this.rows.addElement(blockRow);
    }

    public BlockRow row(int n) {
        Enumeration enumeration = this.rows.elements();
        while (enumeration.hasMoreElements()) {
            BlockRow blockRow = (BlockRow)enumeration.nextElement();
            if (blockRow.seqno != n) continue;
            return blockRow;
        }
        return null;
    }

    public Vector orgRows(String string) {
        Vector<BlockRow> vector = new Vector<BlockRow>();
        Enumeration enumeration = this.rows.elements();
        while (enumeration.hasMoreElements()) {
            BlockRow blockRow = (BlockRow)enumeration.nextElement();
            String string2 = this.bf.seqname(blockRow.seqno);
            if (!Util.orgName(string2).equals(string) || string2.endsWith("~")) continue;
            vector.addElement(blockRow);
        }
        return vector;
    }

    public Range getExtent(int n) {
        BlockRow blockRow = this.row(n);
        return blockRow == null ? null : blockRow.getExtent();
    }

    public BlockText toText(int n) {
        int n2 = this.rows.size();
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        int[] nArray = new int[n2];
        int n3 = 0;
        BlockRow blockRow = this.row(n);
        if (blockRow == null) {
            return null;
        }
        stringArray[n3] = blockRow.text;
        stringArray2[n3] = this.bf.mafseqname(blockRow.seqno);
        nArray[n3] = blockRow.seqno;
        ++n3;
        Enumeration enumeration = this.rows.elements();
        while (enumeration.hasMoreElements()) {
            blockRow = (BlockRow)enumeration.nextElement();
            if (blockRow.seqno == n) continue;
            stringArray[n3] = Util.dotify(blockRow.text, stringArray[0]);
            stringArray2[n3] = this.bf.mafseqname(blockRow.seqno);
            nArray[n3] = blockRow.seqno;
            ++n3;
        }
        if (n3 != stringArray.length) {
            Log.fatalBug("Block.toText(): Wrong number of rows.");
        }
        return new BlockText(stringArray, stringArray2, nArray);
    }

    public int rowOrder(int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (n5 < this.rows.size()) {
            BlockRow blockRow = (BlockRow)this.rows.elementAt(n5);
            if (blockRow.seqno == n2) {
                n3 = n5;
            }
            if (blockRow.seqno == n) {
                n4 = n5;
            }
            if (n3 >= 0 && n4 >= 0) {
                int n6;
                int n7 = n3 == n4 ? 0 : (n6 = n3 < n4 ? n4 : n4 + 1);
                if (this.rowAt(n6, n2) != this.row(n)) {
                    Log.fatalBug("Block.rowOrder(): Conflict with rowAt().");
                }
                return n6;
            }
            ++n5;
        }
        return -1;
    }

    public BlockRow rowAt(int n, int n2) {
        if (n > this.rows.size()) {
            return null;
        }
        int n3 = 0;
        while (n3 < this.rows.size()) {
            BlockRow blockRow = (BlockRow)this.rows.elementAt(n3);
            if (blockRow.seqno == n2) {
                int n4 = n == 0 ? n3 : (n <= n3 ? n - 1 : n);
                BlockRow blockRow2 = (BlockRow)this.rows.elementAt(n4);
                return blockRow2;
            }
            ++n3;
        }
        return null;
    }
}

