/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.bx.gmaj;

import edu.psu.bx.gmaj.Bar;
import edu.psu.bx.gmaj.BarList;
import edu.psu.bx.gmaj.Config;
import edu.psu.bx.gmaj.Maj;
import edu.psu.bx.gmaj.MajState;
import edu.psu.bx.gmaj.ZoomPane;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;

class BarPane
extends ZoomPane {
    static final String rcsid = "$Revision: 1.4 $$Date: 2007/03/30 20:14:46 $";
    static final int barBottom = 0;
    static final int barTop = 100;
    Vector scores;
    BarList bars;

    BarPane(Maj maj, MajState majState, Vector vector) {
        super(maj, majState, 0, 100);
        this.scores = vector;
    }

    void paintContents(Graphics graphics) {
        this.paintBars(graphics);
    }

    private void paintBars(Graphics graphics) {
        this.bars = new BarList(this.scores, this.w2s);
        graphics.setColor(Config.barColor);
        Enumeration enumeration = this.bars.bars.elements();
        while (enumeration.hasMoreElements()) {
            Bar bar = (Bar)enumeration.nextElement();
            this.paintBar(graphics, bar);
        }
    }

    private void paintBar(Graphics graphics, Bar bar) {
        int n = this.w2s.transformX(bar.start);
        int n2 = this.w2s.transformX(bar.end);
        int n3 = this.w2s.transformY(0);
        int n4 = this.w2s.transformY(0 + Math.round(bar.score * 100.0f));
        int n5 = n2 - n;
        int n6 = n3 - n4;
        graphics.fillRect(n, n4, n5 + 1, n6 + 1);
    }

    void showMouseLoc(Point point) {
        float f = (float)(point.y - 0) / 100.0f;
        this.state.showBarLoc(point.x, f, this.bars.findBar(point.x));
    }

    void doClick(Point point) {
    }
}

